/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.CompositeModelState;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemMultiLayerBakedModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public final class CombModel
implements IModelGeometry<CombModel> {
    public static final CombModel INSTANCE = new CombModel((ImmutableList<Material>)ImmutableList.of());
    public ImmutableList<Material> textures;
    public final ImmutableSet<Integer> fullBrightLayers;

    public CombModel(ImmutableList<Material> textures) {
        this(textures, (ImmutableSet<Integer>)ImmutableSet.of());
    }

    public CombModel(@Nullable ImmutableList<Material> textures, ImmutableSet<Integer> fullBrightLayers) {
        this.textures = textures;
        this.fullBrightLayers = fullBrightLayers;
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((ModelState)new CompositeModelState(owner.getCombinedTransform(), modelTransform));
        TextureAtlasSprite particle = spriteGetter.apply(owner.isTexturePresent("particle") ? owner.resolveTexture("particle") : (Material)this.textures.get(0));
        ItemMultiLayerBakedModel.Builder builder = ItemMultiLayerBakedModel.builder((IModelConfiguration)owner, (TextureAtlasSprite)particle, (ItemOverrides)new Overrides(this, overrides, modelTransform, owner, spriteGetter), (ImmutableMap)transformMap);
        return builder.build();
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        while (owner.isTexturePresent("layer" + i)) {
            Material mat = owner.resolveTexture("layer" + i);
            builder.add((Object)mat);
            ++i;
        }
        this.textures = builder.build();
        return this.textures;
    }

    private static BakedModel bakeModel(IModelConfiguration owner, Material texture, Function<Material, TextureAtlasSprite> spriteGetter, ImmutableMap<ItemTransforms.TransformType, Transformation> transformMap, ItemOverrides overrides) {
        TextureAtlasSprite sprite = spriteGetter.apply(texture);
        ImmutableList quads = ItemLayerModel.getQuadsForSprite((int)-1, (TextureAtlasSprite)sprite, (Transformation)Transformation.m_121093_());
        return new BakedItemModel(quads, sprite, transformMap, overrides, true, owner.isSideLit());
    }

    public static class Overrides
    extends ItemOverrides {
        private final Map<String, BakedModel> modelCache = Maps.newHashMap();
        private final CombModel combModel;
        private final ItemOverrides nested;
        private final ModelState modelTransform;
        private final IModelConfiguration owner;
        private final Function<Material, TextureAtlasSprite> spriteGetter;

        private Overrides(CombModel combModel, ItemOverrides nested, ModelState modelTransform, IModelConfiguration owner, Function<Material, TextureAtlasSprite> spriteGetter) {
            this.combModel = combModel;
            this.nested = nested;
            this.modelTransform = modelTransform;
            this.owner = owner;
            this.spriteGetter = spriteGetter;
        }

        @Nullable
        public BakedModel m_173464_(@Nonnull BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity livingEntity, int seed) {
            CompoundTag tag = stack.m_41737_("EntityTag");
            if (tag != null && tag.m_128441_("type")) {
                String beeType = tag.m_128461_("type");
                if (!this.modelCache.containsKey(beeType)) {
                    CompoundTag nbt = BeeReloadListener.INSTANCE.getData(beeType);
                    if (nbt == null) {
                        this.modelCache.put(beeType, model);
                    } else {
                        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((ModelState)new CompositeModelState(this.owner.getCombinedTransform(), this.modelTransform));
                        if (nbt.m_128441_("combTexture")) {
                            Material texture = ModelLoaderRegistry.blockMaterial((String)nbt.m_128461_("combTexture"));
                            BakedModel texturedModel = CombModel.bakeModel(this.owner, texture, this.spriteGetter, (ImmutableMap<ItemTransforms.TransformType, Transformation>)transformMap, this.nested);
                            this.modelCache.put(beeType, texturedModel);
                        } else {
                            TextureAtlasSprite baseSprite = this.spriteGetter.apply((Material)this.combModel.textures.get(0));
                            ItemMultiLayerBakedModel.Builder builder = ItemMultiLayerBakedModel.builder((IModelConfiguration)this.owner, (TextureAtlasSprite)baseSprite, (ItemOverrides)this.nested, (ImmutableMap)transformMap);
                            boolean fullBright = this.combModel.fullBrightLayers.contains((Object)0);
                            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)fullBright), (Collection)ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)baseSprite, (Transformation)this.modelTransform.m_6189_(), (boolean)fullBright));
                            if (nbt.m_128441_("renderer") && nbt.m_128461_("renderer").equals("default_crystal")) {
                                TextureAtlasSprite crystalSprite = this.spriteGetter.apply((Material)this.combModel.textures.get(1));
                                fullBright = this.combModel.fullBrightLayers.contains((Object)1);
                                builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)fullBright), (Collection)ItemLayerModel.getQuadsForSprite((int)1, (TextureAtlasSprite)crystalSprite, (Transformation)this.modelTransform.m_6189_(), (boolean)fullBright));
                            }
                            this.modelCache.put(beeType, builder.build());
                        }
                    }
                }
                return this.modelCache.getOrDefault(beeType, model);
            }
            return model;
        }
    }

    public static class Loader
    implements IModelLoader<CombModel> {
        public static final Loader INSTANCE = new Loader();

        public void m_6213_(@Nonnull ResourceManager resourceManager) {
        }

        @Nonnull
        public CombModel read(@Nonnull JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ImmutableSet.Builder fullbrightLayers = ImmutableSet.builder();
            if (modelContents.has("fullbright_layers")) {
                JsonArray arr = GsonHelper.m_13933_((JsonObject)modelContents, (String)"fullbright_layers");
                for (int i = 0; i < arr.size(); ++i) {
                    fullbrightLayers.add((Object)arr.get(i).getAsInt());
                }
            }
            return new CombModel(null, (ImmutableSet<Integer>)fullbrightLayers.build());
        }
    }
}

